#instalar paquetes requeridos:
install.packages("readxl")
install.packages("dplyr")
install.packages("ggplot2")
install.packages("GGally")
install.packages("corrplot")
install.packages("PerformanceAnalytics")
#leer los paquetes
library(readxl)
library(dplyr)
library(ggplot2)
library(corrplot)
library(PerformanceAnalytics)
#Cargamos la base de datos completa, para análisis general de la correlación entre variables.
BASE_DATAJAM <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                           +     sheet = "INTERNET FIJO", col_types = c("numeric", 
                                                                        +         "text", "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric", "numeric", 
                                                                        +         "numeric"))
head(BASE_DATAJAM)
str(BASE_DATAJAM)
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM)
#Revisamos la Matriz de correlación de las variables
round(cor(x = na.omit(BASE_DATAJAM)[c(1,3,4,5,6,7,8,9,10,11,12,13,14,15)], method = "pearson"),2)
#Cargamos la base de datos sólo para el 2015, para análisis más detallado de la correlación entre variables.
library(readxl)
BASE_DATAJAM15 <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                               +     sheet = "IF 2015", col_types = c("numeric", 
                                                                      +         "text", "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric"))
View(BASE_DATAJAM15)                                                                                              
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM15)
#Revisamos la Matriz de correlación de las variables para el año 2015
round(cor(x = na.omit(BASE_DATAJAM15)[c(1,3,4,5,6,7,8,9,10,11,12,13,14,15)], method = "pearson"),2)
#Cargamos la base de datos sólo para el 2016, para análisis más detallado de la correlación entre variables.
library(readxl)
BASE_DATAJAM16 <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                               +     sheet = "IF 2016", col_types = c("numeric", 
                                                                      +         "text", "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric"))
View(BASE_DATAJAM16)    
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM16)
#Revisamos la Matriz de correlación de las variables para el año 2016
round(cor(x = na.omit(BASE_DATAJAM16)[c(3,4,5,6,7,8,9,10,11,12,13,14,15)], method = "pearson"),2)
#Cargamos la base de datos sólo para el 2017, para análisis más detallado de la correlación entre variables.
BASE_DATAJAM17 <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                               +     sheet = "IF 2017", col_types = c("numeric", 
                                                                      +         "text", "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric"))
View(BASE_DATAJAM17) 
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM17)
#Revisamos la Matriz de correlación de las variables para el año 2017
round(cor(x = na.omit(BASE_DATAJAM17)[c(3,4,5,6,7,8,9,10,11,12,13,14,15)], method = "pearson"),2)
#Cargamos la base de datos sólo para el 2018, para análisis más detallado de la correlación entre variables.
library(readxl)
BASE_DATAJAM18 <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                               +     sheet = "IF 2018", col_types = c("numeric", 
                                                                      +         "text", "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric"))
View(BASE_DATAJAM18) 
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM18)
#Revisamos la Matriz de correlación de las variables para el año 2018
round(cor(x = na.omit(BASE_DATAJAM18)[c(3,4,5,6,7,8,9,10,11,12,13,14,15)], method = "pearson"),2)
#Cargamos la base de datos sólo para el 2019, para análisis más detallado de la correlación entre variables.
library(readxl)
BASE_DATAJAM19 <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                               +     sheet = "IF 2019", col_types = c("numeric", 
                                                                      +         "text", "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric", "numeric", "numeric", 
                                                                      +         "numeric"))
View(BASE_DATAJAM19)   
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM19)
#Revisamos la Matriz de correlación de las variables para el año 2019
round(cor(x = na.omit(BASE_DATAJAM19)[c(4,5,6,7,8,9,10,11,12,13,14,15)], method = "pearson"),2)

#Cargamos la base de datos sólo para el Departamento de Santander, para análisis más detallado de la correlación entre variable
#dadas las particularidades del Departamento.
library(readxl)
BASE_DATAJAM_Santander <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                                       +     sheet = "Santander", col_types = c("numeric", 
                                                                                +         "text", "numeric", "numeric", "numeric", 
                                                                                +         "numeric", "numeric", "numeric", 
                                                                                +         "numeric", "numeric", "numeric", 
                                                                                +         "numeric", "numeric"))
View(BASE_DATAJAM_Santander) 
head(BASE_DATAJAM_Santander)
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM_Santander)
str(na.omit(BASE_DATAJAM_Santander))
#Revisamos la Matriz de correlación de las variables para el departamento de Santander
round(cor(x = na.omit(BASE_DATAJAM_Santander)[c(1,3,4,5,6,7,8,9,10,11,12,13)], method = "pearson"),2)
#Cargamos la base de datos sólo para el Departamento del archipiélago de San Andrñes, para análisis más detallado de la correlación entre variable
#dadas las particularidades del Departamento.
library(readxl)
BASE_DATAJAM_SAI <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                                 +     sheet = "Archi_SAI", col_types = c("numeric", 
                                                                          +         "text", "numeric", "numeric", "numeric", 
                                                                          +         "numeric", "numeric", "numeric", 
                                                                          +         "numeric", "numeric", "numeric", 
                                                                          +         "numeric"))
View(BASE_DATAJAM_SAI)    
head(BASE_DATAJAM_SAI)
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM_SAI)
str(na.omit(BASE_DATAJAM_SAI))
#Revisamos la Matriz de correlación de las variables para el departamento de Archipiélago de San Andrés
round(cor(x = na.omit(BASE_DATAJAM_SAI)[c(1,3,4,5,6,7,8,9,10,11,12)], method = "pearson"),2)
#Cargamos la base de datos sólo para el Departamento de Caquetá, para análisis más detallado de la correlación entre variable
#dadas las particularidades del Departamento.
library(readxl)
BASE_DATAJAM_Caqueta <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                                     +     sheet = "Caquetá", col_types = c("numeric", 
                                                                            +         "text", "numeric", "numeric", "numeric", 
                                                                            +         "numeric", "numeric", "numeric", 
                                                                            +         "numeric", "numeric", "numeric", 
                                                                            +         "numeric", "numeric"))

View(BASE_DATAJAM_Caqueta)
head(BASE_DATAJAM_Caqueta)
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM_Caqueta)
str(na.omit(BASE_DATAJAM_Caqueta))
#Revisamos la Matriz de correlación de las variables para el departamento de Caquetá
round(cor(x = na.omit(BASE_DATAJAM_Caqueta)[c(1,3,4,5,6,7,8,9,10,11,12,13)], method = "pearson"),2)
#Cargamos la base de datos sólo para el Departamento de Cauca, para análisis más detallado de la correlación entre variable
#dadas las particularidades del Departamento.
library(readxl)
BASE_DATAJAM_Cauca <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                                   +     sheet = "Cauca", col_types = c("numeric", 
                                                                        +         "text", "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric"))
View(BASE_DATAJAM_Cauca)  
head(BASE_DATAJAM_Cauca)
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM_Cauca)
str(na.omit(BASE_DATAJAM_Cauca))
#Revisamos la Matriz de correlación de las variables para el departamento de Cauca
round(cor(x = na.omit(BASE_DATAJAM_Cauca)[c(1,3,4,5,6,7,8,9,10,11,12,13)], method = "pearson"),2)
#Cargamos la base de datos sólo para el Departamento de Putumayo, para análisis más detallado de la correlación entre variable
#dadas las particularidades del Departamento.
library(readxl)
BASE_DATAJAM_Putumayo <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                                      +     sheet = "Putumayo", col_types = c("numeric", 
                                                                              +         "text", "numeric", "numeric", "numeric", 
                                                                              +         "numeric", "numeric", "numeric", 
                                                                              +         "numeric", "numeric", "numeric", 
                                                                              +         "numeric"))
View(BASE_DATAJAM_Putumayo)   
head(BASE_DATAJAM_Putumayo)
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM_Putumayo)
str(na.omit(BASE_DATAJAM_Putumayo))
#Revisamos la Matriz de correlación de las variables para el departamento de Cauca
round(cor(x = na.omit(BASE_DATAJAM_Putumayo)[c(1,3,4,5,6,7,8,9,10,11,12)], method = "pearson"),2)
#Cargamos la base de datos sólo para el Departamento de Valle del Cauca, para análisis más detallado de la correlación entre variable
#dadas las particularidades del Departamento.
library(readxl)
BASE_DATAJAM_Valle <- read_excel("Desktop/DATAJAM/BASE_DATAJAM.xlsx", 
                                   +     sheet = "Valle", col_types = c("numeric", 
                                                                        +         "text", "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric", "numeric", 
                                                                        +         "numeric", "numeric"))
View(BASE_DATAJAM_Valle) 
head(BASE_DATAJAM_Valle)
#Realizamos eliminacición de las observaciones sin datos (NA)
na.omit(BASE_DATAJAM_Valle)
str(na.omit(BASE_DATAJAM_Valle))
#Revisamos la Matriz de correlación de las variables para el departamento de Cauca
round(cor(x = na.omit(BASE_DATAJAM_Valle)[c(1,3,4,5,6,7,8,9,10,11,12,13)], method = "pearson"),2)
str(BASE_DATAJAM)
#Modelo departamentos
mod_linealD1 <- lm(PIB_Corrientes ~ Q_suscriptores + Tasa_Tecnologia_FTTx + Promedio_velocidad_downMbps + Total_Poblacion + No_Matriculas_academicas + No_Sedes_con_Internet, data=BASE_DATAJAM)
summary(mod_linealD1)

#Modelo departamental Santander (prueba)
mod_linealD2 <- lm(PIB_Corrientes ~  Q_suscriptores + Tasa_Tecnologia_FTTx + Promedio_velocidad_downMbps + Total_Poblacion + No_Matriculas_academicas, data=(BASE_DATAJAM_Santander))
summary(mod_linealD2)

#selección de variables significativas
step(mod_linealD1, direction = "both", trace = 0)
#Realizamos un Nuevo Modelo
mod_linealD3 <- lm(PIB_Corrientes ~ Q_suscriptores + Promedio_velocidad_downMbps + Total_Poblacion + No_Matriculas_academicas + No_Sedes_con_Internet, data=BASE_DATAJAM)
summary(mod_linealD3)
#Validación de condiciones (Análisis de los residuos - distribución, variabilidad...)
par(mfrow=c(2,2))
plot (mod_linealD3)

